/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.service;

import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;

public class PETrace {
    private static final String PE_TRACE_KEY = "PE_TRACE_KEY";
    private static final String TRACE_MASKT = "XRVTRACT";
    private static final String TRACE_MASKF = "XRVTRACF";

    public static synchronized String start(Map userData, String traceFileName, int maxTraceFileSize, int maxNumberTraceFiles) {
        Trace.trace(TRACE_MASKT, "-> Starting PETrace for file(" + traceFileName + "),maxsize(" + maxTraceFileSize + "),maxnum(" + maxNumberTraceFiles + ")");
        PETraceControl control = new PETraceControl(maxTraceFileSize);
        userData.put(PE_TRACE_KEY, control);
        try {
            PETrace.pruneOldTraceFiles(traceFileName, maxNumberTraceFiles);
            String datedTraceFileName = traceFileName + PETrace.getNow() + ".trm";
            File fileToWrite = new File(datedTraceFileName);
            FileOutputStream fos = new FileOutputStream(fileToWrite);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 1000);
            control.setOutputStream(bos);
            Trace.trace(TRACE_MASKT, "<- PETrace file: " + datedTraceFileName);
            return datedTraceFileName;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-! Exception caught during PETrace.start for file " + traceFileName + ", PETrace NOT started");
            Trace.trace(TRACE_MASKT, "Exception: " + e);
            Trace.trace(TRACE_MASKT, e);
            userData.put(PE_TRACE_KEY, null);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void stop(Map userData) {
        PETraceControl control = (PETraceControl)userData.get(PE_TRACE_KEY);
        try {
            if (control != null) {
                OutputStream outputStream = control.getOutputStream();
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            } else {
                Trace.trace(TRACE_MASKT, "PETrace.stop PE_TRACE_KEY not set in userData Map (PETrace.start not called???)");
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "PETrace.stop Exception caught stopping PETrace: " + e);
            Trace.trace(TRACE_MASKT, e);
        }
        finally {
            userData.put(PE_TRACE_KEY, null);
        }
    }

    public static void petrace(Map userData, String debugString) {
        try {
            PETraceControl control = (PETraceControl)userData.get(PE_TRACE_KEY);
            if (control != null) {
                control.addTraceEntry(PETrace.formatTraceEntry(debugString));
            } else {
                Trace.trace(TRACE_MASKF, "PETrace: " + debugString);
            }
        }
        catch (Exception e) {
            System.out.println("exception caught writing PETrace entry - skipping");
        }
    }

    public static void petrace(Map userData, Throwable throwable) {
        try {
            StackTraceElement[] ste = throwable.getStackTrace();
            String debugString = "Exception: " + throwable.getClass() + "\n";
            for (int i = 0; i < ste.length; ++i) {
                debugString = debugString + ste[i].getClassName() + ":" + ste[i].getLineNumber() + "\n";
            }
            PETraceControl control = (PETraceControl)userData.get(PE_TRACE_KEY);
            if (control != null) {
                control.addTraceEntry(PETrace.formatTraceEntry(debugString));
            } else {
                Trace.trace(TRACE_MASKF, "PETrace: " + debugString);
            }
        }
        catch (Exception e) {
            System.out.println("exception caught writing PETrace entry - skipping");
        }
    }

    private static String formatTraceEntry(String debugString) {
        String lineNumber;
        String filename;
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (ste != null && ste.length > 2) {
            filename = ste[2].getFileName();
            int trailer = filename.indexOf(".java");
            if (trailer != -1) {
                filename = filename.substring(0, trailer);
            }
            lineNumber = String.valueOf(ste[2].getLineNumber());
        } else {
            filename = "**unknown**";
            lineNumber = "???";
        }
        String date = PETrace.getNow();
        int tid = Thread.currentThread().hashCode();
        String sTid = String.valueOf(tid);
        int pad = 0;
        if (tid < 1000000000) {
            ++pad;
            if (tid < 100000000) {
                ++pad;
                if (tid < 10000000) {
                    ++pad;
                    if (tid < 1000000) {
                        ++pad;
                        if (tid < 100000) {
                            ++pad;
                            if (tid < 10000) {
                                ++pad;
                                if (tid < 1000) {
                                    ++pad;
                                    if (tid < 100) {
                                        ++pad;
                                        if (tid < 10) {
                                            ++pad;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        while (pad > 0) {
            sTid = "0" + sTid;
            --pad;
        }
        return date + ":" + sTid + ":" + filename + "(" + lineNumber + ") " + debugString;
    }

    private static String getNow() {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        String sYear = String.valueOf(year);
        int month = c.get(2) + 1;
        String sMonth = (month > 10 ? "" : "0") + String.valueOf(month);
        int day = c.get(5);
        String sDay = (day > 10 ? "" : "0") + String.valueOf(day);
        int hour = c.get(10);
        String sHour = (hour > 10 ? "" : "0") + String.valueOf(hour);
        int min = c.get(12);
        String sMin = (min > 10 ? "" : "0") + String.valueOf(min);
        int sec = c.get(13);
        String sSec = (sec > 10 ? "" : "0") + String.valueOf(sec);
        int milsec = c.get(14);
        String sMilsec = (milsec > 99 ? "" : (milsec < 10 ? "00" : "0")) + String.valueOf(milsec);
        String date = sYear + sMonth + sDay + sHour + sMin + sSec + sMilsec;
        return date;
    }

    private static void pruneOldTraceFiles(String traceFileFilter, int maxNumberTraceFiles) {
        Trace.trace(TRACE_MASKT, "PETrace.pruneOldTraceFiles for filenames: " + traceFileFilter);
        String traceFileDirectory = ".";
        int seperatorIndex = traceFileFilter.lastIndexOf("/");
        if (seperatorIndex != -1) {
            traceFileDirectory = traceFileFilter.substring(0, seperatorIndex);
        }
        final String traceFileName = traceFileFilter.substring(seperatorIndex + 1);
        Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles directory to search: " + traceFileDirectory);
        File directory = new File(traceFileDirectory);
        if (directory.isDirectory()) {
            Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles directory found");
            Object[] matchingFiles = directory.listFiles(new FilenameFilter(){

                public boolean accept(File directory, String fileName) {
                    if (fileName.startsWith(traceFileName) && fileName.endsWith(".trm")) {
                        Trace.trace(PETrace.TRACE_MASKF, "PETrace.pruneOldTraceFiles - match:" + fileName);
                        return true;
                    }
                    Trace.trace(PETrace.TRACE_MASKF, "PETrace.pruneOldTraceFiles - mismatch:" + fileName);
                    return false;
                }
            });
            if (matchingFiles == null) {
                Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles - no matching files found");
            } else {
                Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles - number matching files: " + matchingFiles.length);
            }
            if (matchingFiles != null && matchingFiles.length >= maxNumberTraceFiles) {
                Arrays.sort(matchingFiles);
            }
            for (int aii = 0; aii < matchingFiles.length - maxNumberTraceFiles; ++aii) {
                Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles - removing:" + matchingFiles[aii]);
                ((File)matchingFiles[aii]).delete();
            }
        } else {
            Trace.trace(TRACE_MASKF, "PETrace.pruneOldTraceFiles directory NOT found");
        }
    }

    private static class PETraceControl {
        private static final byte[] NL = new byte[]{10};
        private int size = 0;
        private boolean done = false;
        private OutputStream outputStream = null;
        private int maxTraceFileSize = 0;

        public PETraceControl(int maxTraceFileSize) {
            this.maxTraceFileSize = maxTraceFileSize;
        }

        public void addTraceEntry(String debugString) {
            if (!this.done) {
                if ((this.size += debugString.length()) > this.maxTraceFileSize) {
                    if (this.outputStream != null) {
                        try {
                            this.outputStream.write(new String("MAX trace file size reached (" + this.maxTraceFileSize + ").  Trace halted").getBytes());
                        }
                        catch (Exception toss) {
                            // empty catch block
                        }
                    }
                    this.done = true;
                } else if (this.outputStream != null) {
                    try {
                        this.outputStream.write(debugString.getBytes());
                        if (!debugString.endsWith("\n")) {
                            this.outputStream.write(NL);
                        }
                    }
                    catch (Exception toss) {
                        System.out.println(toss);
                    }
                }
            }
        }

        public void setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        protected void finalize() {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

